<?php
/**
 * Admin notification email
 */

$order_id = $order->get_order_number();
$opening_paragraph = __('A new payment for order #%s has been received and the details are as follows:', 'htppg1-email');
?>

<?php do_action('woocommerce_email_header', $email_heading); ?>

<?php
if ($order ) : ?>
    <p><?php printf($opening_paragraph, $order_id); ?></p>
<?php endif; ?>

<table cellspacing="0" cellpadding="6" style="width: 100%; border: 1px solid #eee;" border="1" bordercolor="#eee">
    <tbody>
        <tr>
            <th scope="row" style="text-align:left; border: 1px solid #eee;"><?php _e('Order ID', 'htppg1-email'); ?></th>
            <td style="text-align:left; border: 1px solid #eee;">
                <a href="<?php echo admin_url('post.php?post=' . $order_id . '&action=edit'); ?>" target="_blank"># <?php echo $order_id; ?></a>
            </td>
        </tr>
        <tr>
            <th scope="row" style="text-align:left; border: 1px solid #eee;"><?php _e('Invoice No.', 'htppg1-email'); ?></th>
            <td style="text-align:left; border: 1px solid #eee;">{invoice_no}</td>
        </tr>
        <tr>
            <th scope="row" style="text-align:left; border: 1px solid #eee;"><?php _e('Transaction ID', 'htppg1-email'); ?></th>
            <td style="text-align:left; border: 1px solid #eee;">{transaction_id}</td>
        </tr>
        <tr>
            <th scope="row" style="text-align:left; border: 1px solid #eee;"><?php _e('Amount Requested', 'htppg1-email'); ?></th>
            <td style="text-align:left; border: 1px solid #eee;">{requested_amount}</td>
        </tr>
        <tr>
            <th scope="row" style="text-align:left; border: 1px solid #eee;"><?php _e('Amount Paid', 'htppg1-email'); ?></th>
            <td style="text-align:left; border: 1px solid #eee;">{paid_amount}</td>
        </tr>
    </tbody>
</table>

<p> <br />
    <?php _e('This email sent due to amount / currency received is mismatch with the orginal amount. '
        . ' Order is marked as "Awaiting confirm" until the details are manally reviewed and approve', 'htppg1-email'); ?>
</p>
<p>
    <?php echo make_clickable(sprintf(__('You can view and edit this order in the dashboard here: %s', 'htppg1-email'), admin_url('post.php?post=' . $order_id . '&action=edit'))); ?>
</p>

<?php do_action('woocommerce_email_footer');