<?php
/**
 * Plugin Name: Howtopay WP Plugin for WC
 * Plugin URI: https://howtopay.com/
 * Description:  Howtopay wordpress plugin for woocommerce - Blocks supported.
 * Version: 4.0.1
 * Author: HowToPay
 * Author URI: https://howtopay.com
 * Text Domain: howtopay
 * Domain Path: /i18n/languages/
 * 
 */
defined('ABSPATH') || exit;
$pathinfo = pathinfo(__FILE__);

define('HOWTOPAY_PLUGIN_VERSION',"3.0.7");  //@TODO: update with every version
define('HOWTOPAY_PLUGINURL', plugins_url('', __FILE__) . "/");
define('HOWTOPAY_PLUGINDIR', $pathinfo['dirname'] . '/');
define('HOWTOPAY_PLUGINFILE', __FILE__); 
define('HOWTOPAY_PGNONCE_KEY', 'howtopay-ajax-nonce-Oa8x3UN9E0j6GD');

if (!class_exists('Howtopay', false)) {

    class Howtopay {
        
        public $notification_meta_box_title = "Howtopay Notifications";
        public $gateway_name = 'howtopay';
        
        function init() { 
            add_action('wp_loaded', array(&$this, 'admin_init'));  
            //add_action('wp_loaded', array(&$this, 'test'));   
            
            add_action("add_meta_boxes", array(&$this, 'howtopay_meta_box'));
            add_action("woocommerce_order_details_after_order_table", array(&$this, 'howtopay_qr_code')); 
            add_action("woocommerce_order_details_before_order_table", array(&$this, 'howtopay_email_message')); 
            
            add_action( 'init', array(&$this, 'register_custom_post_status'), 20 );
            add_filter( 'wc_order_statuses', array(&$this, 'custom_wc_order_statuses'), 20, 1 );
            add_filter( 'bulk_actions-edit-shop_order', array(&$this, 'custom_dropdown_bulk_actions_shop_order'), 20, 1 );
            //add_filter( 'woocommerce_email_actions', array(&$this, 'custom_email_actions'), 20, 1 );
            //add_action( 'woocommerce_order_status_wc-awaiting-confirm', array( WC(), 'send_transactional_email' ), 10, 1 );
            //add_action('woocommerce_order_status_awaiting-confirm', 'backorder_status_custom_notification', 20, 2);
            
            add_action( 'woocommerce_admin_order_totals_after_total', array(&$this, 'action_woocommerce_admin_order_item_values'), 10, 3 );

        }  
        
        function action_woocommerce_admin_order_item_values( $order_id ) {
            
            $order = new WC_Order($order_id);
            
            $_trn_numbers = $order->get_meta('_trn_numbers');
            $_trn_numbers_json = (array)json_decode($_trn_numbers);

            if(!empty($_trn_numbers_json)) {
                echo "<br/><strong>Transaction(s) History: </strong><br/>";
            } else {
                return;
            } 
            
            $tr = "";
            
            foreach($_trn_numbers_json as $trn=>$val) {
                $tr .= "<tr>"
                        . "<td>".$trn."</td>"
                        . "<td>".$val->time."</td>"
                        . "<td>".$val->currency. " " .$val->amount."</td>"
                    . "</tr>";
                //echo $trn . " | " . $val->time . " | " . $val->currency . " " . $val->amount . "<br />";
            }
            
            if($tr != "") {
                echo "<table style='width:100%;float:right;max-width:500px;'><thead><tr>"
                    . "<th>TID</th>"
                    . "<th>Paid at</th>"
                    . "<th>Paid Amount</th>"
                . "</tr></thead>";
                echo $tr;
                echo "</table>";
            }
        }
        
        public function howtopay_meta_box($post_type) {   
            global $post;
            if (get_post_meta($post->ID, 'howtopay_payment_method', 'yes') == $this->gateway_name) {
                add_meta_box("howtopay_callback_notification_options", $this->notification_meta_box_title, array(&$this, 'howtopay_callback_notification'), "shop_order", "advanced", "high", null);
            }
        } 
        public function howtopay_email_message($order) {
             $invoice_no = get_post_meta($order->get_id(), 'howtopay_payment_id', 'yes');  
            if ($order->get_payment_method() == $this->gateway_name) {
                if (trim($invoice_no) != '') { 
                    include_once HOWTOPAY_PLUGINDIR . 'templates/Email_message.php';
                }
            }
        }
        public function howtopay_qr_code($order) {
            $invoice_no = get_post_meta($order->get_id(), 'howtopay_payment_id', 'yes');  
            if ($order->get_payment_method() == $this->gateway_name) {
                if (trim($invoice_no) != '') { 
                    include_once HOWTOPAY_PLUGINDIR . 'templates/QR_code.php';
                }
            }
        } 

        function howtopay_callback_notification($object) { 
            wp_nonce_field(basename(__FILE__), "meta-box-nonce");
            $post_id = (isset($_GET['post']) && $_GET['post'] !== "") ? $_GET['post'] : ""; 
            $order_metas = get_post_meta($post_id, 'howtopay_callbacks_msg');
            
            if (!empty($order_metas)) {
                $order_metas = json_decode($order_metas[0], TRUE);
            }

            if (!is_array($order_metas)) {
                $order_metas = array();
            }
            
             include_once HOWTOPAY_PLUGINDIR . 'templates/Notifications.php';
        } 

        public function page_notification($type, $post) {
            
            global $woocommerce;
            
            $yrn = isset($post['yrn']) ? trim($post['yrn']) : '';
             $payment_id = isset($post['payment_id']) ? trim($post['payment_id']) : '';
            $status = isset($post['status']) ? trim($post['status']) : '';
//            $type = isset($post['type']) ? trim($post['type']) : '';
            $yrn = intval($yrn);   
            
            if ($type != '' && $status != ''  && $yrn > 0) {
                $invoice_no = get_post_meta($yrn, 'howtopay_payment_id');
                if (!empty($invoice_no) && trim($invoice_no[0]) == $payment_id && $payment_id != '') {
                    $order_meta = get_post_meta($yrn, 'howtopay_callbacks_msg', 'yes');
                    if (!is_null($order_meta)) {
                        $order_meta = json_decode($order_meta, TRUE);
                    }
                    if (empty($order_meta)) {
                        $order_meta = array();
                    }
                    $order_meta[strtotime('now')] = $type.' '.$status;
                    update_post_meta($yrn, 'howtopay_callbacks_msg', json_encode($order_meta));
                    echo json_encode(array('type' => 'success', 'message' => 'Save changes successfuly.'));
                } else {
                    echo json_encode(array('type' => 'error', 'message' => 'Payment id not detected.'));
                }
            } else {
                echo json_encode(array('type' => 'error', 'message' => '00200 : Invalid request.'));
            }
            
            exit();
        }

        /*
          wc-pending - Pending payment
          wc-processing - Processing
          wc-on-hold - On hold
          wc-failed - Failed
          wc-completed - Completed
          wc-cancelled - Cancelled
          wc-refunded - Refunded
         */

        function update_order_status($order, $status, $note) {
            $order->update_status($status, $note, true);
        }
        
        function save_trns($order, $trn, $amount_paid, $currency_paid) {

            $_trn_numbers = $order->get_meta('_trn_numbers');
            
            if($_trn_numbers !== "" && $_trn_numbers != NULL) {
                $_trn_numbers = json_decode($_trn_numbers,TRUE);
            } else {
                $_trn_numbers = array();
            }

            if(!empty($_trn_numbers) && isset($_trn_numbers[$trn])) {
                return false;
            } else {
                $_trn_numbers[$trn] = array("amount"=>$amount_paid, "currency"=>$currency_paid, "time"=>date("Y-m-d H:i:s"));
                $order->update_meta_data( '_trn_numbers', json_encode($_trn_numbers));
                $order->save();
                return true;
            }

        }
        
        function is_duplicate_payment($order, $trn) { 
            $_trn_numbers = $order->get_meta('_trn_numbers'); 
            
            
            if($_trn_numbers !== "" && $_trn_numbers != NULL) {
                $_trn_numbers = @json_decode($_trn_numbers,true);
            } else {
                $_trn_numbers = array();
            } 
            
            if(!empty($_trn_numbers) && isset($_trn_numbers[$trn])) {
                return true;
            } else {
                return false;
            }
        }

        function get_demo_trn() {
            
            $post = array();
            
            $post['991234567891'] = array("amount"=>"10.55", "currency"=>"AUD", "time"=>"2020-10-02 12:05:10");
            $post['991234567892'] = array("amount"=>"15.00", "currency"=>"AUD", "time"=>"2020-10-03 12:05:10");
            $post['991234567893'] = array("amount"=>"25.00", "currency"=>"USD", "time"=>"2020-10-04 12:05:10");

            return json_encode($post);
            
        }
        
        function get_demo_post() {
            
            $post = array();
            
            $post['amount_requested'] = "17.00";
            $post['currency_requested'] = "USD";
            $post['amount_paid'] = "18.00";
            $post['currency_paid'] = "USD";
            $post['trn'] = "TEST-012345678-1";
            $post['invoice_no'] = "7001234567";
            
            return $post;
            
        }
        
        function send_awaiting_confirmation_email_admin($order_id, $type, $post) { //$order_id
                
            //$post = $this->get_demo_post(); //@TODO: Remove this

            //$order = wc_get_order( $order_id );
            // Only for "pending" order status
            //if( $order->has_status( 'pending' ) ) return;

            $wc_email = WC()->mailer()->get_emails()['HTPPG1_Email_Admin'];

            $heading =  __(ucfirst($type). ' payment received and need manaul intervene');
            $subject = __('{site_title} - '.ucfirst($type).' payment received for order #'.$order_id);
            $admin_email = get_option('admin_email');
            
            $wc_email->heading = $heading;
            $wc_email->subject = $subject;
            $wc_email->recipient = ",".$admin_email;
            $wc_email->settings['heading'] = $heading; 
            $wc_email->settings['subject'] = $subject;
            $wc_email->settings['recipient'] = ",".$admin_email;

            //$wc_email->settings['recipient'] .= ',name@email.com'; // Add email recipients (coma separated)

            $contexts['topline'] = "A new payment for order #".$order_id." has been received and the details are as follows:";

            if($type == "under") {
                $contexts['bottomline'] = "This email sent due to amount received is mismatch with the orginal amount. "
                        . "Order is marked as \"Awaiting confirm\" until the details are manally reviewed and approve";
            }
            else if($type == "over") {
                $contexts['bottomline'] = "This email sent due to amount received is mismatch with the orginal amount. "
                        . "Order is marked as \"Completed\"";
            }
            else if($type == "duplicate") {
                $contexts['bottomline'] = "This email sent due to duplicate payments received for your oder #".$order_id.". "
                        . "Duplicate paymentes must identified and handled properly.";
            }
            else if($type == "multiple") {
                $contexts['bottomline'] = "This email sent due to multiple  payments received for your oder #".$order_id.". ";
            }

            $r = $wc_email->trigger_notification_email( $order_id, $post, $contexts, false);
        }
        
        function send_awaiting_confirmation_email_customer($order_id, $type, $post) { //$order_id

            $order = wc_get_order( $order_id );
             
            $wc_email = WC()->mailer()->get_emails()['HTPPG1_Email_Admin']; 
            
            $heading =  __('Receipt for your payment - Order #'.$order_id);
            $subject = __('{site_title} - Receipt for your payment - Order #'.$order_id);
            $billing_email = $order->get_billing_email(); 
            //var_dump($billing_email);
            
            $wc_email->heading = $heading;
            $wc_email->subject = $subject;
            $wc_email->recipient = ",".$billing_email;
            $wc_email->settings['heading'] = $heading; 
            $wc_email->settings['subject'] = $subject;
            $wc_email->settings['recipient'] = ",".$billing_email;

            $contexts['topline'] = "A new payment for order #".$order_id." has been received and the details are as follows:";

            if($type == "under") {
                $contexts['bottomline'] = "This payment is correctly identified and allocated in our system.";
            }
            else if($type == "over") {
                $contexts['bottomline'] = "This payment is correctly identified and allocated in our system.";
            }
            else if($type == "duplicate") {
                $contexts['bottomline'] = "This payment is correctly identified and allocated in our system.";
            }

            $r = $wc_email->trigger_notification_email( $order_id, $post, $contexts, true);
            
        }
        
        function write_log_file($data) {
            //write to file for testing : @TODO: REMOVE
            $myfile = fopen(dirname(__FILE__)."/logs/log". strtotime(date('Y-m-d H:i:s')). "-". rand(100,10000) . ".txt", "w") or die("Unable to open file!");
            
            ob_flush();
            ob_start();
            var_dump($data);
            $data = ob_get_clean();

            $str = print_r($data, true);
            fwrite($myfile, $str);
            fclose($myfile);
        }
        
        function htp_update_order_status($order_id, $post) { //$post  //@TODO: add this to func params
            
            global $woocommerce;
                
            $order = new WC_Order($order_id);
            $trn = isset($post['trn']) ? $post['trn'] : "";

            $isDuplicate = $this->is_duplicate_payment($order, $trn);
            
            if($isDuplicate === true) {
                $return = json_encode(array('type' => 'error', 'message' => "DUPLICATE CALLBACK|REJECTED|RECEIVED OK"));
                //$this->write_log_file($return); //TODO: remove
                echo $return;
                exit;
            }
            
            $currency_requested = isset($post['currency_requested']) ? $post['currency_requested']: "";
            $amount_requested = isset($post['amount_requested']) ? $post['amount_requested']: "";
            $currency_paid = isset($post['currency_paid']) ? $post['currency_paid']: "";
            $amount_paid = isset($post['amount_paid']) ? $post['amount_paid'] : "";
            
            $invoice_no = isset($post['invoice_no']) ? $post['invoice_no'] : "";

            $multi_payment = isset($post['multi_payment']) ? trim($post['multi_payment']) : "0";
            $over_payment = isset($post['over_payment']) ? trim($post['over_payment']) : "0";
            $overpaid_amount = isset($post['overpaid_amount']) ? trim($post['overpaid_amount']) : "0";
            $under_payment = isset($post['under_payment']) ? trim($post['under_payment']) : "0";
            $underpaid_amount = isset($post['underpaid_amount']) ? trim($post['underpaid_amount']) : "0";

            if($currency_paid == "" || $amount_paid == "" || $trn == "" || $invoice_no == "") {
                if($trn == "") echo json_encode(array('type' => 'error', 'message' => 'TRN cannot be empty')); 
                if($currency_paid == "") echo json_encode(array('type' => 'error', 'message' => 'Currency Paid cannot be empty')); 
                if($amount_paid == "") echo json_encode(array('type' => 'error', 'message' => 'Amount Paid cannot be empty')); 
                if($invoice_no == "") echo json_encode(array('type' => 'error', 'message' => 'Invoice Number cannot be empty'));                 
                return false;
            }


            if($currency_requested == "") {
                $currency_requested = $order->get_currency();
            }

            if($amount_requested == "") {
                $amount_requested = $order->get_total();
            }

            if($currency_requested == "" || $amount_requested == "") {
                if($currency_requested == "")
                    echo json_encode(array('type' => 'error', 'message' => 'Requested currency cannot be empty'));
                if ($amount_requested == "")
                    echo json_encode(array('type' => 'error', 'message' => 'Requested amount cannot be empty'));
                return false;
            } 

            $returnString = "|";  
             
            if ($over_payment == '1') {
                $this->send_awaiting_confirmation_email_customer($order_id, "over", $post);
                $this->send_awaiting_confirmation_email_admin($order_id, "over", $post);
                $returnString .= "OVER|";
            } 
            if ($under_payment == '1') {
                $this->update_order_status($order, 'wc-awaiting-confirm', "Awaiting confirmation due to paid details mismatch");
                $this->save_trns($order, $trn, $amount_paid, $currency_paid);
             
                $this->send_awaiting_confirmation_email_customer($order_id, "under", $post);
                $this->send_awaiting_confirmation_email_admin($order_id, "under", $post);
                $returnString .= "UNDER|";
            } else {
                $this->update_order_status($order, 'wc-processing', "Order Paid");

                WC()->payment_gateways();
                WC()->shipping();
                WC()->mailer()->customer_invoice($order);

                $this->save_trns($order, $trn, $amount_paid, $currency_paid);
            }

             
            if($multi_payment == '1'){
                 //send multiple notification
                 $this->send_awaiting_confirmation_email_admin($order_id, "multiple", $post);
                 $returnString .= "MULTIPLE|";
            }

            echo json_encode(array('type' => 'success', 'message' => "|RECEIVED OK". $returnString));
            exit;
        } 
    
        public function page_callback($post) {
            
            global $woocommerce;
             
            $yrn = isset($post['yrn']) ? trim($post['yrn']) : '';
            $payment_id = isset($post['payment_id']) ? trim($post['payment_id']) : '';
//            $payment_id = isset($post['payment_request_id']) ? trim($post['payment_request_id']) : '';
            $type = isset($post['status']) ? strtolower(trim($post['status'])) : '';
            $yrn = intval($yrn);
            
            if ($type != '' && $yrn > 0) { 
                
                $invoice_no = get_post_meta($yrn, 'howtopay_payment_id');
                if (!empty($invoice_no) && trim($invoice_no[0]) == $payment_id && $payment_id != '') {
                    $meta = get_post_meta($yrn);
                    if (!empty($meta)) {
                        try {
                            $order = new WC_Order($yrn);
                            if ($order) {
                                if ('paid' == $type) {  
                                    //$order->update_status('wc-completed', '', true); 
                                    //$order->update_status('completed', "Order paid", true);
                                    
                                    $this->htp_update_order_status($yrn, $post);
                                } 
                                else if ('cancel' == $type || 'expire' == $type) {
                                    $order->update_status('wc-cancelled', '', true);
                                    echo json_encode(array('type' => 'success', 'message' => 'Save changes successfuly.'));
                                } 
                                else {
                                    echo json_encode(array('type' => 'error', 'message' => '00304 : Invalid request'));
                                }
                            }
                        } catch (Exception $ex) {
                            echo json_encode(array('type' => 'error', 'message' => '00303 : Invalid request'));
                        }
                    } else {
                        echo json_encode(array('type' => 'error', 'message' => '00302 : Invalid request'));
                    }
                } else {
                    echo json_encode(array('type' => 'error', 'message' => '00301 : Invalid request'));
                }
            } else {
                echo json_encode(array('type' => 'error', 'message' => '00300 : Invalid request'));
            }
            exit();
        }

        function admin_init() {
            $page = isset($_GET['page']) ? trim($_GET['page']) : '';
            $action = isset($_GET['action']) ? trim($_GET['action']) : '';
            $wp_version = isset($_GET['wp_version']) ? trim($_GET['wp_version']) : '';
                        
            if ($page == 'howtopay' && ($action == 'notification' || $action == 'callback')) { 
                
                $response = file_get_contents("php://input");    
                $response = json_decode($response, true); 
                
                //write to file for testing : @TODO: REMOVE
                //$this->write_log_file($response);
                
                 
                if (!empty($response)) {
                    $signature = isset($response['signature']) ? trim($response['signature']) : '';
                    //$this->write_log_file($signature);
                    
                    $post = isset($response['data']) ? $response['data'] : array(); 
                    if ($signature != '') {
                        $settings = get_option('woocommerce_howtopay_settings');
                        if (!empty($settings)) {
                            $api_key = isset($settings['api_public_key']) ? trim($settings['api_public_key']) : '';
                            $secret_key = isset($settings['api_secret_key']) ? trim($settings['api_secret_key']) : ''; 
                            if ($api_key != '' && $secret_key != '') {
                                $signature_ = $this->get_signature($api_key, $secret_key, $post, $wp_version);
                                //$this->write_log_file($signature ." - ". $signature_);
                                
                                if ($signature_ == $signature) {
                                    if ($action == 'notification') {
                                        $type = isset($response['type'])?trim($response['type']):'';
                                        $this->page_notification($type, $post);
                                    }
                                    if ($action == 'callback') {
                                        $this->page_callback($post);
                                    }
                                } else {
                                    echo json_encode(array('type' => 'error', 'message' => '00306 : Signature mis-match'));
                                }
                                exit();
                            }
                        }
                    }
                }
            }
            
            if (is_admin()) {
                wp_enqueue_style('howtopay_style', plugins_url('css/style.css', HOWTOPAY_PLUGINFILE), array(), "1.0.2");
            }
            
            //$this->test();
        } 
 
        function get_api_url() {
            return "https://api.howtopay.com/v2/";
        }

        function get_string_to_sign($json_string) {
            return md5($json_string);
        }

        function get_signature($api_key, $secret_key, $post, $wp_version="") {
            $json_string = json_encode($post);
            $json_string = $this->get_string_to_sign($json_string); 
            $signature = "";
            
            if($wp_version != "" && version_compare($wp_version,'3.0.6', '>=')) {
                //if new method
                $signature = hash_hmac('sha256', $json_string, $secret_key); //@GOOD
            } else {
                //if old method 
                $signature = hash_hmac('sha256', $secret_key, $json_string); 
            }
            
            return $signature;
        }

        function reqeust($api_key, $secret_key, $action, $post,$is_sanbox) {
            if($is_sanbox){
                   $post['api_mode'] = 'sandbox'; 
            }
            
            $post['api_mode'] = 'live'; //@TODO : change
            
            $signature = $this->get_signature($api_key, $secret_key, $post, HOWTOPAY_PLUGIN_VERSION); 
               
             
            
            $curl = curl_init();  
            curl_setopt_array($curl, array(
                CURLOPT_URL => $this->get_api_url() . $action,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "POST",
                CURLOPT_POSTFIELDS => json_encode($post),
                CURLOPT_HTTPHEADER => array(
                    "cache-control: no-cache",
                    "content-type: application/json",
                    "htp-apiversion: HTPAPIv2",
                    "htp-authorization: HTPAPIv2Auth " . $api_key . ":" . $signature,
                    "htp-timestamp: UNIX TIME (1505325876486)" 
                ),
            )); 

            $response = curl_exec($curl);
            $err = curl_error($curl);

            curl_close($curl); 
 
            /*if($action == 'create/payment_request'){ 
                //echo "howtopay : ";echo "<pre>"; var_dump($post); echo "</pre>";echo "<pre>"; var_dump(json_encode($post)); 
                //echo "</pre>";echo "<pre>"; var_dump($response); echo "</pre>";
                //exit(); 
            }*/
              
            if ($err) {
                return array(
                    'type' => "error",
                    "short_message" => 'curl_not_respond',
                    "message" => $err,
                    "data" => array()
                );
            } else {
                $response = json_decode($response, TRUE);
                if (isset($response['type']) && trim($response['type']) == 'error') {
                    return array(
                        'type' => "error",
                        "short_message" => ( isset($response['short_message']) ? trim($response['short_message']) : 'curl_not_respond' ),
                        "message" => ( isset($response['message']) ? trim($response['message']) : '00100 : Invalid Request' ),
                        "data" => array()
                    );
                } else {
                    $signature = isset($response['signature']) ? trim($response['signature']) : '';
                    $post = isset($response['data']) ? $response['data'] : array();
                                        
                    if ($signature != '') {
                        $signature_ = $this->get_signature($api_key, $secret_key, $post, HOWTOPAY_PLUGIN_VERSION);
                        if ($signature_ == $signature) {
                            return array(
                                'type' => "success",
                                "data" => $post
                            );
                        } else {
                            return array(
                                'type' => "error",
                                "short_message" => 'curl_not_respond',
                                "message" => '00102 : Invalid Request',
                                "data" => array()
                            );
                        }
                    } else {
                        return array(
                            'type' => "error",
                            "short_message" => 'curl_not_respond',
                            "message" => '00101 : Invalid Request',
                            "data" => array()
                        );
                    }
                }
            }

            exit();
        }
        
        // register a custom post status 'awaiting-confirm' for Orders
        function register_custom_post_status() {
            register_post_status( 'wc-awaiting-confirm', array(
                'label'                     => _x( 'Awaiting Confirm', 'Order status', 'woocommerce' ),
                'public'                    => true,
                'exclude_from_search'       => false,
                'show_in_admin_all_list'    => true,
                'show_in_admin_status_list' => true,
                'label_count'               => _n_noop( 'Awaiting Confirm <span class="count">(%s)</span>', 'Awaiting Confirm <span class="count">(%s)</span>', 'woocommerce' )
            ) );
        }

        // Adding custom status 'awaiting-confirm' to order edit pages dropdown
        function custom_wc_order_statuses( $order_statuses ) {
            $order_statuses['wc-awaiting-confirm'] = _x( 'Awaiting Confirm', 'Order status', 'woocommerce' );
            return $order_statuses;
        }

        // Adding custom status 'awaiting-confirm' to admin order list bulk dropdown
        function custom_dropdown_bulk_actions_shop_order( $actions ) {
            $actions['mark_awaiting-confirm'] = __( 'Mark Awaiting Confirm', 'woocommerce' );
            return $actions; 
        }

        // Adding action for 'awaiting-confirm'
        function custom_email_actions( $action ) {
            $actions[] = 'woocommerce_order_status_wc-awaiting-confirm';
            return $actions;
        }

        // Sending an email notification when order get 'awaiting-confirm' status
        
    }

    $howtopay = new Howtopay();
    $howtopay->init();
}
  

include_once HOWTOPAY_PLUGINDIR . 'Class/Ajax_functions.php';
include_once HOWTOPAY_PLUGINDIR . 'Class/Howtopay_gateway.php';
include_once HOWTOPAY_PLUGINDIR . 'Class/htppg1-email-manager.php';

add_filter('woocommerce_payment_gateways', 'how_add_gateway_load');
add_action('wp_footer', 'run_htpgateway_scripts');

function run_htpgateway_scripts() {
    if(is_view_order_page()) { 
        global $wp;
        $order_id = wc_clean( $wp->query_vars['view-order'] );
        $_order = wc_get_order($order_id);
        
        if(is_object($_order) && $_order->get_payment_method() == "howtopay") {
            wp_enqueue_script('howtopay_script', plugins_url('js/script.js', HOWTOPAY_PLUGINFILE));
            wp_enqueue_script('howtopay_qr_code', plugins_url('js/qrcode.js', HOWTOPAY_PLUGINFILE));
            wp_localize_script('howtopay_script', 'HOWTOPAY', array('ajaxurl' => admin_url('admin-ajax.php'), 'PGNonce' => wp_create_nonce(HOWTOPAY_PGNONCE_KEY)));
            wp_enqueue_style('howtopay_style', plugins_url('css/style.css', HOWTOPAY_PLUGINFILE), array(), "1.0.2");
        }
        
    }
}

function how_add_gateway_load($gateways) {
    $gateways[] = 'WC_Howtopay_Gateway'; 
    return $gateways; 
}

add_action('plugins_loaded', 'how_init_gateway_load');



function declare_cart_checkout_blocks_compatibility() {
    if (class_exists('\Automattic\WooCommerce\Utilities\FeaturesUtil')) {
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('cart_checkout_blocks', __FILE__, true);
    }
}

add_action('before_woocommerce_init', 'declare_cart_checkout_blocks_compatibility');

add_action('woocommerce_blocks_loaded', 'oawoo_register_order_approval_payment_method_type');

function oawoo_register_order_approval_payment_method_type() {
    if (!class_exists('Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType')) {
        return;
    }

    require_once plugin_dir_path(__FILE__) . 'blocks/class-block.php';

    add_action(
            'woocommerce_blocks_payment_method_type_registration', function( Automattic\WooCommerce\Blocks\Payments\PaymentMethodRegistry $payment_method_registry ) {
        $payment_method_registry->register(new WC_Howtopay_Gateway_Blocks);
    }
    );
}
