<?php
if (!class_exists('howtopay_ajax_functions')): 

    class howtopay_ajax_functions {

        function __construct() {
            $this->ajax_events();
        }

        function ajax_events() {
            add_action('wp_ajax_get_rq_code', array(&$this, 'get_rq_code'));
            add_action('wp_ajax_nopriv_get_rq_code', array(&$this, 'get_rq_code'));
            
            add_action('wp_ajax_get_order_status', array(&$this, 'get_order_status'));
            add_action('wp_ajax_nopriv_get_order_status', array(&$this, 'get_order_status'));
        }

        function howtopay_verify_nonce() {
            $pgnonce = $_POST['pgnonce'];
            
            if (!wp_verify_nonce($pgnonce, HOWTOPAY_PGNONCE_KEY))
                die('Busted!');
        } 

        function get_order_status() {
              global $woocommerce;
            
            $this->howtopay_verify_nonce();
            
            $order_id = isset($_POST['order_id']) ? trim($_POST['order_id']) : '0';
            if ($order_id != '') {              
                $order = wc_get_order($order_id);
                if ($order) {
                    $order_id = $order->get_status();
                    include_once HOWTOPAY_PLUGINDIR . 'templates/Order_status.php';
                    exit();
                }
            } 
        }

        function get_rq_code() {
            
            $this->howtopay_verify_nonce();
            
            $message = array();
            $product_id = isset($_POST['product_id']) ? trim($_POST['product_id']) : '';
            $order_id = isset($_POST['id']) ? trim($_POST['id']) : '';
            
            if ($product_id != '' && $order_id != '' && $order_id > 0) {
                $settings = get_option('woocommerce_howtopay_settings');
                if (!empty($settings)) {
                    $api_key = isset($settings['api_public_key']) ? trim($settings['api_public_key']) : '';
                    $secret_key = isset($settings['api_secret_key']) ? trim($settings['api_secret_key']) : '';
                    $is_sanbox = isset($settings['is_sanbox']) && trim($settings['is_sanbox']) == 'yes' ? true :  FALSE;

                    if ($api_key != '' && $secret_key != '') {
                        $order = wc_get_order($order_id);
                        if ($order) {
                            $order_status = $order->get_status();
                            if ($order_status == 'pending') {
                                $howtopay = new Howtopay();
                                $action = "order/rq_qrcode";
                                $post = array(
                                    'product_id' => $product_id,
                                );
                                $results = $howtopay->reqeust($api_key, $secret_key, $action, $post,$is_sanbox);
                                if ($results['type'] == "success") {
                                    $message = $results;
                                } else {
                                    $message = $results;
                                }
                            } else {
                                $message = array(
                                    'type' => "error",
                                    "short_message" => 'qr_code_generating_error',
                                    "message" => 'QR code cannot generate',
                                    "data" => array()
                                );
                            }
                        } else {
                            $message = array(
                                'type' => "error",
                                "short_message" => 'qr_code_generating_error',
                                "message" => 'QR code cannot generate',
                                "data" => array()
                            );
                        }
                    } else {
                        $message = array(
                            'type' => "error",
                            "short_message" => 'qr_code_generating_error',
                            "message" => 'QR code cannot generate',
                            "data" => array()
                        );
                    }
                } else {
                    $message = array(
                        'type' => "error",
                        "short_message" => 'qr_code_generating_error',
                        "message" => 'QR code cannot generate',
                        "data" => array()
                    );
                }
            } else {
                $message = array(
                    'type' => "error",
                    "short_message" => 'qr_code_generating_error',
                    "message" => 'QR code cannot generate',
                    "data" => array()
                );
            }
            echo json_encode($message);
            exit;
        } 

    }

    $howtopay_ajax_functions = new howtopay_ajax_functions();
endif;

