<?php
/**
 * Admin notification email
 */

$order_id = $order->get_order_number();
?>

<?php do_action('woocommerce_email_header', $email_heading); ?>

<?php
if ($order ) : ?>
    <p>{context_topline}</p>
<?php endif; ?>

<table cellspacing="0" cellpadding="6" style="width: 100%; border: 1px solid #eee;" border="1" bordercolor="#eee">
    <tbody>
        <tr>
            <th scope="row" style="text-align:left; border: 1px solid #eee;"><?php _e('Order ID', 'htppg1-email'); ?></th>
            <td style="text-align:left; border: 1px solid #eee;">
                <?php if($customer == false) { ?>
                <a href="<?php echo admin_url('post.php?post=' . $order_id . '&action=edit'); ?>" target="_blank"># <?php echo $order_id; ?></a>
                <?php } else { ?>
                <a href="<?php echo $order->get_view_order_url(); ?>" target="_blank"># <?php echo $order_id; ?></a>
                <?php } ?>
            </td>
        </tr>
        <tr>
            <th scope="row" style="text-align:left; border: 1px solid #eee;"><?php _e('Invoice No.', 'htppg1-email'); ?></th>
            <td style="text-align:left; border: 1px solid #eee;">{invoice_no}</td>
        </tr>
        <tr>
            <th scope="row" style="text-align:left; border: 1px solid #eee;"><?php _e('Transaction ID', 'htppg1-email'); ?></th>
            <td style="text-align:left; border: 1px solid #eee;">{transaction_id}</td>
        </tr>
        <tr>
            <th scope="row" style="text-align:left; border: 1px solid #eee;"><?php _e('Amount Requested', 'htppg1-email'); ?></th>
            <td style="text-align:left; border: 1px solid #eee;">{requested_amount}</td>
        </tr>
        <tr>
            <th scope="row" style="text-align:left; border: 1px solid #eee;"><?php _e('Amount Paid', 'htppg1-email'); ?></th>
            <td style="text-align:left; border: 1px solid #eee;">{paid_amount}</td>
        </tr>
    </tbody>
</table>

<p> <br />
    {context_bottomline}
</p>
<p>
    <?php if($customer == false) { ?>
    <?php echo make_clickable(sprintf(__('You can view and edit this order in the dashboard here: %s', 'htppg1-email'), admin_url('post.php?post=' . $order_id . '&action=edit'))); ?>
    <?php } else { ?>
    <?php echo make_clickable(sprintf(__('You can view this order in the dashboard here: %s', 'htppg1-email'), $order->get_view_order_url() )); ?>
    <?php } ?>
</p>

<?php do_action('woocommerce_email_footer');