<?php

/**
 * Handles email sending
 */
class HTPPG1_Email_Manager {

    /**
     * Constructor sets up actions
     */
    public function __construct() {

        // template path
        define('HTPPG1_TEMPLATE_PATH', untrailingslashit(HOWTOPAY_PLUGINDIR) . '/templates/');
        // hook for when order status is changed
        //add_action('woocommerce_order_status_pending', array(&$this, 'htppg1_trigger_email_action'), 10, 2); 
        // include the email class files
        add_filter('woocommerce_email_classes', array(&$this, 'htppg1_init_emails'));

        // Email Actions - Triggers
        $email_actions = array(
            'htppg1_pending_email',
            'htppg1_item_email',
        );

        foreach ($email_actions as $action) {
            add_action($action, array('WC_Emails', 'send_transactional_email'), 10, 10);
        }

        add_filter('woocommerce_template_directory', array($this, 'htppg1_template_directory'), 10, 2);
    }

    public function htppg1_init_emails($emails) {
        // Include the email class file if it's not included already
        if (!isset($emails['HTPPG1_Email_Admin'])) {
            $emails['HTPPG1_Email_Admin'] = include_once( untrailingslashit(HOWTOPAY_PLUGINDIR) .'/emails/class-htppg1-email.php' ); 
        }

        return $emails;
    }

    public function htppg1_trigger_email_action($order_id, $posted) {
        // add an action for our email trigger if the order id is valid
        if (isset($order_id) && 0 != $order_id) {

            new WC_Emails();
            do_action('htppg1_pending_email_notification', $order_id);
        }
    }

    public function htppg1_template_directory($directory, $template) {

        // ensure the directory name is correct
        if (false !== strpos($template, 'custom-')) {
            return 'htppg1-custom-email';
        }

        return $directory;
    }

}

// end of class
new HTPPG1_Email_Manager();
