<?php
function how_init_gateway_load() {  
    
	class WC_Howtopay_Gateway extends WC_Payment_Gateway { 
            
        public function __construct() {
            $howtopay = new Howtopay();
            $this->id = $howtopay->gateway_name;  
            $this->icon = '';  
            $this->has_fields = true; 
            $this->method_title = 'Howtopay';
            $this->method_description = "Howtopay payment gateway for woocommerce";   
            
            $this->supports = array(
                'products'
            );
 
            $this->init_form_fields();
 
            $this->init_settings(); 
            $this->title = $this->get_option('title');
            $this->description = $this->get_option('description');
            $this->enabled = $this->get_option('enabled');
            $this->testmode = 'yes' === $this->get_option('testmode');
            $this->api_link = '';

            $this->public_key = $this->get_option('api_public_key');
            $this->secret_key = $this->get_option('api_secret_key');
            
            $this->is_sanbox = $this->get_option('is_sanbox');

            add_action('woocommerce_update_options_payment_gateways_' . $this->id, array($this, 'process_admin_options'));
            add_action('wp_enqueue_scripts', array($this, 'payment_scripts')); 
            add_action("woocommerce_thankyou_" . $this->id, array(&$this, 'order_status'));
            
            add_filter( 'woocommerce_available_payment_gateways', array($this, 'payment_gateway_disable_country') ); 
             
        }
  
        function user_geo_country() {
            // Get an instance of the WC_Geolocation object class
            $geolocation_instance = new WC_Geolocation();
            
            // Get user IP
            $user_ip_address = $geolocation_instance->get_ip_address();
            
            // Get geolocated user IP country code.
            $user_geolocation = $geolocation_instance->geolocate_ip($user_ip_address);
            
            $user_country = "";
            
            if(isset($user_geolocation['country']) && $user_geolocation['country'] != "") {
                $user_country = $user_geolocation['country'];
            }
            
            return $user_country;
        }

        function get_is_eligible_methods () {
            
            global $woocommerce;
            
            $currency = get_woocommerce_currency();
            $total = WC()->cart->total;
            $howtopay = new Howtopay();
            $action = "gateway/eligible_gateways";
             
            $country = isset($_POST['country']) ? $_POST['country']  : ""; 
            
            if(trim($country) ==''){
                if(!is_object(WC()->customer) || !method_exists(WC()->customer,'get_billing_country')) {
                    $country = $this->user_geo_country();
                } else {
                $country = WC()->customer->get_billing_country();
                } 
            } 
            
            $post = array(
                'country'=> $country,
                'currency' => $currency,
                'total' => $total,
            );
            $is_sanbox = trim($this->is_sanbox) == 'yes' ?true:FALSE;
            $results = $howtopay->reqeust($this->public_key, $this->secret_key, $action, $post,$is_sanbox);  
            
            if ($results['type'] == "success" && !empty($results['data'])) {
                return $results['data'];
            }
            
            return false;
        }
        
        function payment_gateway_disable_country( $available_gateways ) {
            if ( is_admin() ) return $available_gateways;
                        
            if ( isset( $available_gateways['howtopay'] ) && $this->get_is_eligible_methods() === false ) {
                unset( $available_gateways['howtopay'] );
            } 
            
            return $available_gateways;
        }
        
        function order_status($order_id) {
            ?>  <div class="show_howotpay_order_status" data-id="<?php echo $order_id; ?>"> </div> <?php
        }

        public function init_form_fields() { 
            $this->form_fields = array(
                'enabled' => array(
                    'title' => 'Enable/Disable',
                    'label' => 'Enable Howtopay Gateway',
                    'type' => 'checkbox',
                    'description' => '',
                    'default' => 'no'
                ),
                'title' => array(
                    'title' => 'Title',
                    'type' => 'text',
                    'description' => 'This controls the title which the user sees during checkout.',
                    'default' => 'HowToPay',
                    'desc_tip' => true,
                ),
                'description' => array(
                    'title' => 'Description',
                    'type' => 'textarea',
                    'description' => 'This controls the description which the user sees during checkout.',
                    'default' => "<strong style='color:#1398d9'>Pay with HowToPay</strong> &#187;  In next page you'll get the payment link to complete this order. Also we will send you an email with payment options if you want to complete this payment later.",
                ), 
                 'is_sanbox' => array(
                    'title' => 'Howtopay Sandbox',
                    'label' => 'Enable Howtopay Sandbox',
                    'type' => 'checkbox',
                    'description' => '',
                    'default' => 'no'
                ),
                'api_public_key' => array(
                        'title' => 'API Key',
                        'type' => 'text',
                        'description' => 'Merchant API Key',
                        'desc_tip' => true,
                    ),
                    'api_secret_key' => array(
                        'title' => 'Secret Key',
                        'type' => 'text',
                        'description' => 'Merchant Secret Key',
                        'desc_tip' => true,
                    )
            );
        }

        public function payment_fields() { 
            
            $description = $this->get_description();
            
            if ( $description ) {
              echo wpautop( wptexturize( $description ) ); // @codingStandardsIgnoreLine.
            }
                
            /*
            global $woocommerce;
            $currency = get_woocommerce_currency();
            $total = WC()->cart->total;
            $howtopay = new Howtopay();
            $action = "gateway/eligible_gateways";
            $post = array(
                'currency' => $currency,
                'total' => $total,
            );
            $is_sanbox = trim($this->is_sanbox) == 'yes' ?true:FALSE;
            $results = $howtopay->reqeust($this->public_key, $this->secret_key, $action, $post,$is_sanbox);  
            //var_dump($results);exit;
            $gateways = array();
            if ($results['type'] == "success") {
                $gateways = $results['data'];
            } 
            if (!empty($gateways)) {
                $description = $this->get_description();
                if ( $description ) {
                  echo wpautop( wptexturize( $description ) ); // @codingStandardsIgnoreLine.
                }
                //include_once HOWTOPAY_PLUGINDIR . 'templates/Checkout_gatewayt.php';
            }*/
        }

        function getClientIpAddressFromProxy() {
            $useProxy = false;
            $trustedProxies = array();
            $proxyHeader = 'HTTP_X_FORWARDED_FOR'; 
            if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
                $http_x_headers = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
                $_SERVER['REMOTE_ADDR'] = $http_x_headers[0];
            }
            if (!$useProxy || (isset($_SERVER['REMOTE_ADDR']) && !in_array($_SERVER['REMOTE_ADDR'], $trustedProxies))) {
                return false;
            }
            $header = $proxyHeader;
            if (!isset($_SERVER[$header]) || empty($_SERVER[$header])) {
                return false;
            } 
            $ips = explode(',', $_SERVER[$header]); 
            $ips = array_map('trim', $ips); 
            $ips = array_diff($ips, $trustedProxies); 
            if (empty($ips)) {
                return false;
            } 
            $ip = array_pop($ips);
            return $ip;
        }

        function getUserIpAddress() {
            $ip = $this->getClientIpAddressFromProxy();
            if ($ip) {
                return $ip;
            } 
            if (isset($_SERVER['REMOTE_ADDR'])) {
                return $_SERVER['REMOTE_ADDR'];
            } 
            return false;
        }

        public function process_admin_options() {
            if (!empty($_POST['woocommerce_howtopay_enabled']) && $_POST['woocommerce_howtopay_enabled'] = 1) {
                if (empty($_POST['woocommerce_howtopay_api_public_key'])) {
                    WC_Admin_Settings::add_error('Error: API Key cannot be empty');
                    return false;
                }
                if (empty($_POST['woocommerce_howtopay_api_secret_key'])) {
                    WC_Admin_Settings::add_error('Error: Secret Key cannot be empty');
                    return false;
                }
                
                $howtopay = new Howtopay();
                $action = "gateway/check";
                
                $post = array('action' => 'check_connection');
                $api_key = isset($_POST['woocommerce_howtopay_api_public_key']) ? trim($_POST['woocommerce_howtopay_api_public_key']) : "";
                $secret_key = isset($_POST['woocommerce_howtopay_api_secret_key']) ?  trim($_POST['woocommerce_howtopay_api_secret_key']) : "";
                $is_sanbox = (isset($_POST['woocommerce_howtopay_is_sanbox']) && trim($_POST['woocommerce_howtopay_is_sanbox']) == '1') ? true: false;
                
                $results = $howtopay->reqeust($api_key, $secret_key, $action, $post,$is_sanbox);
                if ($results['type'] == "error") {
                    WC_Admin_Settings::add_error('Error: Test connection Api Server fail');
                    return false;
                }
            }
            parent::process_admin_options();
        }

        public function payment_scripts() {
            if ((is_cart() || is_checkout() || isset($_GET['pay_for_order'])) && 'yes' === $this->enabled && !empty($this->public_key) && !empty($this->secret_key)) {
                wp_enqueue_script('howtopay_script', plugins_url('js/script.js', HOWTOPAY_PLUGINFILE));
                wp_enqueue_script('howtopay_qr_code', plugins_url('js/qrcode.js', HOWTOPAY_PLUGINFILE));
                wp_localize_script('howtopay_script', 'HOWTOPAY', array('ajaxurl' => admin_url('admin-ajax.php'), 'PGNonce' => wp_create_nonce(HOWTOPAY_PGNONCE_KEY)));
                wp_enqueue_style('howtopay_style', plugins_url('css/style.css', HOWTOPAY_PLUGINFILE), array(), "1.0.2");
            }
        }

        public function validate_fields() { 
            return true;
        } 
        
        public function process_payment($order_id) {            
            global $woocommerce;
            $order = wc_get_order($order_id);
             
            $howtopay = new Howtopay();
            $action = "create/payment_request";
            
//            $name = trim($order->get_billing_first_name() . ' ' . $order->get_billing_last_name());            
            
            $shipping_address_1 = trim($order->get_shipping_address_1());
            $shipping_address_2 = trim($order->get_shipping_address_2());
            $shipping_city = trim($order->get_shipping_city());
            $shipping_state = trim($order->get_shipping_state());
            $shipping_postcode = trim($order->get_shipping_postcode());
            $shipping_country = trim($order->get_shipping_country());   
            
             $billing_email = trim($order->get_billing_email());   
             $billing_first_name = trim($order->get_billing_first_name());  
             $billing_last_name = trim($order->get_billing_last_name());   
             $billing_address_2 = trim($order->get_billing_address_2());
             $billing_city = trim($order->get_billing_city());
                $billing_state = trim($order->get_billing_state());

            $billing_postcode = trim($order->get_billing_postcode());


            $siteurl = site_url();
            $siteurl = explode('?', $siteurl);
            $siteurl[0] = rtrim(trim($siteurl[0]), '/\\') . '/';
            if (isset($siteurl[1]) && trim($siteurl[1]) != '') {
                $siteurl = $siteurl[0] . '?' . trim($siteurl[1]) . '&';
            } else {
                $siteurl = $siteurl[0] . '?';
            }
             
            $post = array(
                'order' => array(
                    'amount' => base64_encode('' . $order->get_total()),
                    'currency' => base64_encode($order->get_currency()), 
                    'note' => '',
                    'merchant_reference_no' => base64_encode($order_id),
                ),
                'customer' => array(
                    'first_name' => ($billing_first_name == '' ? '' : base64_encode($billing_first_name)),
                    'middle_name' => '',
                    'last_name' => ($billing_last_name == '' ? '' : base64_encode($billing_last_name)),
                    'email' => ($billing_email == '' ? '' : base64_encode($billing_email)),
                    'phone' => base64_encode($order->get_billing_phone()),
                    'gender' => '',
                    'lang' => base64_encode('EN'),
                    'ip_address' => base64_encode($this->getUserIpAddress()),
                ),
                'customer_address' => array(
                    'address1' => base64_encode($order->get_billing_address_1()),
                    'address2' => ($billing_address_2 == '' ? '' : base64_encode($billing_address_2)),
                    'city' => ($billing_city == '' ? '' : base64_encode($billing_city)),
                    'state' => ($billing_state == '' ? '' : base64_encode($billing_state)),
                    'postcode' => ($billing_postcode == '' ? '' : base64_encode($billing_postcode)),
                    'country' => base64_encode($order->get_billing_country()),
                ),
                'customer_shipping_address' => array(
                    'shipping_address1' => ($shipping_address_1 == '' ? '' : base64_encode($shipping_address_1)),
                    'shipping_address2' => ($shipping_address_2 == '' ? '' : base64_encode($shipping_address_2)),
                    'shipping_city' => ($shipping_city == '' ? '' : base64_encode($shipping_city)),
                    'shipping_state' => ($shipping_state == '' ? '' : base64_encode($shipping_state)),
                    'shipping_postcode' => ($shipping_postcode == '' ? '' : base64_encode($shipping_postcode)),
                    'shipping_country' => ($shipping_country == '' ? '' : base64_encode($shipping_country)),
                ),
                'callback_url' => base64_encode($siteurl . 'page=howtopay&action=callback&wp_version='.HOWTOPAY_PLUGIN_VERSION),
                'notification_url' => base64_encode($siteurl . 'page=howtopay&action=notification&wp_version='.HOWTOPAY_PLUGIN_VERSION),
            ); 

            $is_sanbox = trim($this->is_sanbox) == 'yes' ?true:FALSE;

            $results = $howtopay->reqeust($this->public_key, $this->secret_key, $action, $post,$is_sanbox); 
            if ($results['type'] == "error") { 
                wc_add_notice($results['message'], 'error');
                return;
            } else {
                $results = $results['data'];
                update_post_meta($order_id, 'howtopay_payment_id', $results['invoice_no']);
                update_post_meta($order_id, 'howtopay_payment_link', $results['payment_link']);
                update_post_meta($order_id, 'howtopay_direct_links', json_encode($results['direct_links']));
                update_post_meta($order_id, 'howtopay_payment_method', $this->id);
                
                $order->update_status('wc-pending', "New order created", true);
                $woocommerce->cart->empty_cart();
                
                return array(
                    'result' => 'success',
                    'redirect' => $this->get_return_url($order)
                );
            }
        }

    }

}

