<?php
// htp_oc_plugin_v1
class ModelExtensionPaymentHowtopay extends Model {
    public function getMethod($address, $total) {
        $this->load->language('extension/payment/howtopay');

        // Standard OpenCart checks (geo zone, status, total)
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "zone_to_geo_zone WHERE geo_zone_id = '" . (int)$this->config->get('payment_howtopay_geo_zone_id') . "' AND country_id = '" . (int)$address['country_id'] . "' AND (zone_id = '" . (int)$address['zone_id'] . "' OR zone_id = '0')");

        if ($this->config->get('payment_howtopay_total') > 0 && $this->config->get('payment_howtopay_total') > $total) {
            $status = false;
        } elseif (!$this->config->get('payment_howtopay_geo_zone_id')) {
            $status = true;
        } elseif ($query->num_rows) {
            $status = true;
        } else {
            $status = false;
        }

        if (!$this->config->get('payment_howtopay_status')) {
            $status = false;
        }
        
        // If basic checks pass, then check API eligibility
        $method_data = array();

        if ($status) {
            $api_key = $this->config->get('payment_howtopay_api_key');
            $secret_key = $this->config->get('payment_howtopay_secret_key');
            $is_sandbox = (bool)$this->config->get('payment_howtopay_sandbox');

            // Ensure API keys are set before attempting API call
            if ($api_key && $secret_key) {
                $library_file = DIR_SYSTEM . 'library/howtopayapi.php';

                if (file_exists($library_file)) {
                    require_once($library_file);

                    $howtopay_api_client = new HowtopayApi($api_key, $secret_key, $is_sandbox);

                    $current_currency = $this->session->data['currency'];
                    // Use the $total passed to the function, which is the cart total at this stage
                    $cart_total = $total; 

                    // Determine customer's country code
                    $customer_country_code = '';
                    if (isset($address['iso_code_2']) && $address['iso_code_2']) {
                        // iso_code_2 from the $address (payment address)
                        $customer_country_code = $address['iso_code_2'];
                    } elseif (isset($this->session->data['shipping_address']['iso_code_2']) && $this->session->data['shipping_address']['iso_code_2']) {
                        // Fallback to shipping address if payment address country is not available
                        $customer_country_code = $this->session->data['shipping_address']['iso_code_2'];
                    }
                    // You might add a further fallback to $this->config->get('config_country_id') if needed,
                    // but $address should generally be populated at this stage of checkout.

                    if ($customer_country_code && $current_currency) {
                        $api_action = "gateway/eligible_gateways"; // As per your WordPress code
                        $post_data = array(
                            'country'  => $customer_country_code,
                            'currency' => $current_currency,
                            'total'    => $cart_total,
                        );
                        // The HowtopayApi class will add 'api_mode' based on $is_sandbox

                        $results = $howtopay_api_client->request($api_action, $post_data);

                        if (isset($results['type']) && $results['type'] == "success" && !empty($results['data'])) {
                            // Gateway is eligible based on API response
                            $method_data = array(
                                'code'       => 'howtopay',
                                'title'      => $this->language->get('text_title'), // Or $this->config->get('payment_howtopay_title')
                                'terms'      => '', // You can set terms from language file or config if needed
                                'sort_order' => $this->config->get('payment_howtopay_sort_order')
                            );
                        } else {
                            // Not eligible based on API response or API error
                            if ($this->config->get('payment_howtopay_debug')) {
                                $this->log->write('HowToPay Eligibility Check Failed: ' . (isset($results['message']) ? $results['message'] : 'No eligible gateways returned or API error.'));
                                $this->log->write('HowToPay Eligibility Request Data: ' . json_encode($post_data));
                                $this->log->write('HowToPay Eligibility Response: ' . json_encode($results));
                            }
                        }
                    } else {
                        // Country or Currency could not be determined
                        if ($this->config->get('payment_howtopay_debug')) {
                            $this->log->write('HowToPay Eligibility Check Failed: Customer country code or currency could not be determined. Country: ' . $customer_country_code . ', Currency: ' . $current_currency);
                        }
                    }
                } else {
                    // API library file missing
                    if ($this->config->get('payment_howtopay_debug')) {
                        $this->log->write('HowToPay Error: API library file not found at ' . $library_file);
                    }
                }
            } else {
                // API keys not configured
                if ($this->config->get('payment_howtopay_debug')) {
                    $this->log->write('HowToPay Eligibility Check Failed: API Key or Secret Key not configured in admin settings.');
                }
            }
        }

        return $method_data;
    }
}

