<?php 
// htp_oc_plugin_v1
class ControllerExtensionPaymentHowtopay extends Controller {
    public function index() {
        $this->load->language('extension/payment/howtopay');

        // $data['text_instruction'] = $this->language->get('text_instruction');
        // $data['text_description'] = $this->language->get('text_description');
        // $data['text_payment'] = $this->language->get('text_payment');
        
        // If you have a custom description from admin settings:
        $data['description'] = nl2br($this->config->get('payment_howtopay_description'));


        // Add any other data needed for your payment_howtopay.twig template
        // For example, if you need to display specific gateway options AFTER HowToPay is selected,
        // you might make another API call here. But for initial eligibility, the model handles it.

        return $this->load->view('extension/payment/howtopay', $data);
    }

    public function confirm() {
        $json = array();

        if (isset($this->session->data['payment_method']['code']) && $this->session->data['payment_method']['code'] == 'howtopay') {
            $this->load->model('checkout/order');

            // Prepare comment for order history
            $comment_parts = [];
            if ($this->language->get('text_instruction')) {
                $comment_parts[] = $this->language->get('text_instruction');
            }
            if ($this->config->get('payment_howtopay_description')) {
                $comment_parts[] = html_entity_decode($this->config->get('payment_howtopay_description'), ENT_QUOTES, 'UTF-8');
            }
            $comment_parts[] = $this->language->get('text_payment');
            $comment = implode("\n\n", $comment_parts);

            $initial_order_status_id = $this->config->get('payment_howtopay_order_status_id');
            
            if ($this->config->get('payment_howtopay_debug')) {
                $this->log->write('HowToPay Confirm: Using initial order_status_id: ' . $initial_order_status_id . ' for order_id: ' . $this->session->data['order_id']);
            }

            // This is crucial: it finalizes the order in OpenCart and sets its status.
            $this->model_checkout_order->addOrderHistory($this->session->data['order_id'], $initial_order_status_id, $comment, true);
            
            // Here you would typically make the "create/payment_request" API call
            // similar to your WordPress process_payment function.

            $api_key = $this->config->get('payment_howtopay_api_key');
            $secret_key = $this->config->get('payment_howtopay_secret_key');
            $is_sandbox = (bool)$this->config->get('payment_howtopay_sandbox');
            
            $order_info = $this->model_checkout_order->getOrder($this->session->data['order_id']);

            if ($api_key && $secret_key && $order_info) {
                $library_file = DIR_SYSTEM . 'library/howtopayapi.php';
                if (file_exists($library_file)) {
                    require_once($library_file);
                    $howtopay_api_client = new HowtopayApi($api_key, $secret_key, $is_sandbox);

                    // Generate a larger merchant reference number
                    // Example: HTP-YYYYMMDD-ORDERID (e.g., HTP-20231027-00000004)
                    // You can adjust the prefix and padding as needed.
                    $generated_merchant_ref = 'HTP-' . date('Ymd') . '-' . sprintf('%08d', $order_info['order_id']);

                    // Prepare $post_data for 'create/payment_request'
                    $post_data = array(
                        'order' => array(
                            'amount'                => base64_encode($this->currency->format($order_info['total'], $order_info['currency_code'], $order_info['currency_value'], false)),
                            'currency'              => base64_encode($order_info['currency_code']),
                            'merchant_reference_no' => base64_encode($generated_merchant_ref),
                            // Add other order details as required by API
                        ),
                        'customer' => array(
                            'first_name' => base64_encode($order_info['payment_firstname']),
                            'last_name'  => base64_encode($order_info['payment_lastname']),
                            'email'      => base64_encode($order_info['email']),
                            'phone'      => base64_encode($order_info['telephone']),
                            'ip_address' => base64_encode($order_info['ip']),
                            // Add other customer details
                        ),
                        'customer_address' => array(
                            'address1' => base64_encode($order_info['payment_address_1']),
                            'address2' => base64_encode($order_info['payment_address_2']),
                            'city'     => base64_encode($order_info['payment_city']),
                            'state'    => base64_encode($order_info['payment_zone']),
                            'postcode' => base64_encode($order_info['payment_postcode']),
                            'country'  => base64_encode($order_info['payment_iso_code_2']),
                        ),
                        // Add shipping address if different and required
                        'callback_url'     => base64_encode($this->url->link('extension/payment/howtopay/callback', '', true)), // Adjust URL as needed
                        'notification_url' => base64_encode($this->url->link('extension/payment/howtopay/notification', '', true)), // Adjust URL as needed
                    );
                    
                    if ($order_info['shipping_method']) { // Check if shipping is applicable
                        $post_data['customer_shipping_address'] = array(
                            'shipping_address1' => base64_encode($order_info['shipping_address_1']),
                            'shipping_address2' => base64_encode($order_info['shipping_address_2']),
                            'shipping_city'     => base64_encode($order_info['shipping_city']),
                            'shipping_state'    => base64_encode($order_info['shipping_zone']),
                            'shipping_postcode' => base64_encode($order_info['shipping_postcode']),
                            'shipping_country'  => base64_encode($order_info['shipping_iso_code_2']),
                        );
                    }


                    $api_action = "create/payment_request";
                    $results = $howtopay_api_client->request($api_action, $post_data);

                    if (isset($results['type']) && $results['type'] == "success" && !empty($results['data']['payment_link'])) {
                        // Store payment_id, payment_link etc. in your order table or a custom table
                        // Save to custom table including the generated merchant reference
                        $this->db->query("INSERT INTO `" . DB_PREFIX . "howtopay_order` SET `order_id` = '" . (int)$this->session->data['order_id'] . "', `merchant_reference_no` = '" . $this->db->escape($generated_merchant_ref) . "', `howtopay_invoice_no` = '" . $this->db->escape(isset($results['data']['invoice_no']) ? $results['data']['invoice_no'] : '') . "'");

                        $json['redirect'] = $results['data']['payment_link']; // Redirect customer to HowToPay
                    } else {
                        $json['error'] = (isset($results['message']) ? $results['message'] : $this->language->get('error_process_order'));
                         if ($this->config->get('payment_howtopay_debug')) {
                            $this->log->write('HowToPay Create Payment Request Failed: ' . (isset($results['message']) ? $results['message'] : 'API error.'));
                            $this->log->write('HowToPay Create Payment Request Data: ' . json_encode($post_data));
                            $this->log->write('HowToPay Create Payment Request Response: ' . json_encode($results));
                        }
                    }
                } else {
                     $json['error'] = $this->language->get('error_library_missing');
                      if ($this->config->get('payment_howtopay_debug')) {
                        $this->log->write('HowToPay Error: API library file not found at ' . $library_file);
                    }
                }
            } else {
                 $json['error'] = $this->language->get('error_config_missing');
                  if ($this->config->get('payment_howtopay_debug')) {
                    $this->log->write('HowToPay Create Payment Request Failed: API credentials or order info missing.');
                }
            }
        } else {
            $json['error'] = $this->language->get('error_no_payment_method');
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    private function _processIncomingRequest() {
        $this->load->language('extension/payment/howtopay');
        $this->load->model('checkout/order');

        $raw_post_data = file_get_contents('php://input');
        if ($this->config->get('payment_howtopay_debug')) {
            $this->log->write('HowToPay Incoming Request: ' . $raw_post_data);
        }

        $response_data = json_decode($raw_post_data, true);

        if (json_last_error() !== JSON_ERROR_NONE) {
            if ($this->config->get('payment_howtopay_debug')) {
                $this->log->write('HowToPay Incoming Request JSON Decode Error: ' . json_last_error_msg());
            }
            return ['error' => 'Invalid JSON payload', 'payload' => null, 'order_info' => null, 'api_client' => null];
        }

        $signature = isset($response_data['signature']) ? trim($response_data['signature']) : '';
        $payload = isset($response_data['data']) ? $response_data['data'] : null;

        if (empty($signature) || empty($payload)) {
            if ($this->config->get('payment_howtopay_debug')) {
                $this->log->write('HowToPay Incoming Request Error: Missing signature or data payload.');
            }
            return ['error' => 'Missing signature or data', 'payload' => $payload, 'order_info' => null, 'api_client' => null];
        }

        $api_key = $this->config->get('payment_howtopay_api_key');
        $secret_key = $this->config->get('payment_howtopay_secret_key');
        $is_sandbox = (bool)$this->config->get('payment_howtopay_sandbox'); // Sandbox status might be relevant for API client if it behaves differently

        if (!$api_key || !$secret_key) {
            if ($this->config->get('payment_howtopay_debug')) {
                $this->log->write('HowToPay Incoming Request Error: API credentials not configured.');
            }
            return ['error' => 'API credentials not configured', 'payload' => $payload, 'order_info' => null, 'api_client' => null];
        }

        $library_file = DIR_SYSTEM . 'library/howtopayapi.php';
        if (!file_exists($library_file)) {
            if ($this->config->get('payment_howtopay_debug')) {
                $this->log->write('HowToPay Error: API library file not found at ' . $library_file);
            }
            return ['error' => 'API library not found', 'payload' => $payload, 'order_info' => null, 'api_client' => null];
        }
        require_once($library_file);
        $howtopay_api_client = new HowtopayApi($api_key, $secret_key, $is_sandbox);

        if (!$howtopay_api_client->verifySignature($signature, $payload)) {
            if ($this->config->get('payment_howtopay_debug')) {
                $this->log->write('HowToPay Incoming Request Error: Invalid signature.');
                $this->log->write('HowToPay Received Signature: ' . $signature);
                // $this->log->write('HowToPay Expected Signature (for data): ' . $howtopay_api_client->getSignature($payload)); // getSignature is private, can't call directly here for logging
            }
            return ['error' => 'Invalid signature', 'payload' => $payload, 'order_info' => null, 'api_client' => $howtopay_api_client];
        }

        // yrn from payload is our generated merchant_reference_no
        $merchant_ref_from_payload = isset($payload['yrn']) ? trim($payload['yrn']) : '';
        // payment_id is the HowToPay invoice_no
        $howtopay_invoice_no_from_payload = isset($payload['payment_id']) ? trim($payload['payment_id']) : '';

        if (empty($merchant_ref_from_payload)) {
            if ($this->config->get('payment_howtopay_debug')) {
                $this->log->write('HowToPay Incoming Request Error: Missing merchant reference (yrn) in payload.');
            }
            return ['error' => 'Missing merchant reference (yrn)', 'payload' => $payload, 'order_info' => null, 'api_client' => $howtopay_api_client];
        }

        // Fetch original order_id and howtopay_invoice_no from your custom table using the merchant_reference_no
        $howtopay_order_query = $this->db->query("SELECT `order_id`, `howtopay_invoice_no` FROM `" . DB_PREFIX . "howtopay_order` WHERE `merchant_reference_no` = '" . $this->db->escape($merchant_ref_from_payload) . "'");

        if (!$howtopay_order_query->num_rows) {
            if ($this->config->get('payment_howtopay_debug')) {
                $this->log->write('HowToPay Incoming Request Error: No HowToPay order data found for merchant reference: ' . $merchant_ref_from_payload);
            }
            return ['error' => 'HowToPay order data not found for merchant reference', 'payload' => $payload, 'order_info' => null, 'api_client' => $howtopay_api_client];
        }

        $original_order_id = (int)$howtopay_order_query->row['order_id'];
        $stored_howtopay_invoice_no = $howtopay_order_query->row['howtopay_invoice_no'];

        if (!$original_order_id) {
             if ($this->config->get('payment_howtopay_debug')) {
                $this->log->write('HowToPay Incoming Request Error: Original order ID not found for merchant reference: ' . $merchant_ref_from_payload);
            }
            return ['error' => 'Original order ID not found', 'payload' => $payload, 'order_info' => null, 'api_client' => $howtopay_api_client];
        }

        $order_info = $this->model_checkout_order->getOrder($original_order_id);

        if (!$order_info) {
            if ($this->config->get('payment_howtopay_debug')) {
                $this->log->write('HowToPay Incoming Request Error: Order not found for original ID: ' . $original_order_id . ' (derived from merchant_ref: ' . $merchant_ref_from_payload . ')');
            }
            return ['error' => 'Order not found using original ID', 'payload' => $payload, 'order_info' => null, 'api_client' => $howtopay_api_client];
        }


        if (empty($stored_howtopay_invoice_no) || $stored_howtopay_invoice_no != $howtopay_invoice_no_from_payload) {
            if ($this->config->get('payment_howtopay_debug')) {
                $this->log->write('HowToPay Incoming Request Error: Payment ID mismatch for order ID ' . $order_id . '. Expected: ' . $stored_howtopay_invoice_no . ', Received: ' . $howtopay_invoice_no_from_payload);
            }
            return ['error' => 'Payment ID mismatch', 'payload' => $payload, 'order_info' => $order_info, 'api_client' => $howtopay_api_client];
        }

        return ['error' => null, 'payload' => $payload, 'order_info' => $order_info, 'api_client' => $howtopay_api_client, 'response_type' => isset($response_data['type']) ? trim($response_data['type']) : null];
    }

    public function callback() {
        $processed_request = $this->_processIncomingRequest();

        if ($processed_request['error']) {
            $this->response->addHeader('Content-Type: application/json');
            $this->response->setOutput(json_encode(['type' => 'error', 'message' => $processed_request['error']]));
            return;
        }

        $payload = $processed_request['payload'];
        $order_info = $processed_request['order_info'];
        $order_id = $order_info['order_id'];

        $status_from_payload = isset($payload['status']) ? strtolower(trim($payload['status'])) : '';
        $comment = 'HowToPay Callback Received. Status: ' . $status_from_payload . '. Payload: ' . json_encode($payload);

        $new_order_status_id = $order_info['order_status_id']; // Default to current status

        if ($status_from_payload == 'paid') {
            // Check for underpayment, overpayment if your API provides such flags
            $under_payment = isset($payload['under_payment']) && $payload['under_payment'] == '1';

            if ($under_payment) {
                $new_order_status_id = $this->config->get('payment_howtopay_underpayment_status_id');
                $comment .= ' Order marked as Underpaid.';
            } else {
                // Exact or overpayment
                $new_order_status_id = $this->config->get('payment_howtopay_paid_status_id');
                $comment .= ' Order marked as Paid.';
            }
        } elseif ($status_from_payload == 'cancel' || $status_from_payload == 'expire') {
            $new_order_status_id = $this->config->get('payment_howtopay_cancelled_status_id');
            $comment .= ' Order marked as Cancelled/Expired.';
        } else {
            // Unknown status, or a status that doesn't require an immediate state change but should be logged
            $comment .= ' Unknown or unhandled status from HowToPay.';
            if ($this->config->get('payment_howtopay_debug')) {
                $this->log->write("HowToPay Callback: Unhandled status '{$status_from_payload}' for order ID {$order_id}.");
            }
             // Optionally set to a 'failed' or 'review' status
            // $new_order_status_id = $this->config->get('payment_howtopay_failed_status_id');
        }

        if ($new_order_status_id && $order_info['order_status_id'] != $new_order_status_id) {
            $this->model_checkout_order->addOrderHistory($order_id, $new_order_status_id, $comment, true); // true to notify customer
        } else {
            // Log even if status doesn't change, or if no specific status mapping
            $this->model_checkout_order->addOrderHistory($order_id, $order_info['order_status_id'], $comment, false); // false to not notify if status is same
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode(['type' => 'success', 'message' => 'Callback processed.']));
    }

    public function notification() {
        $processed_request = $this->_processIncomingRequest();

        if ($processed_request['error']) {
            $this->response->addHeader('Content-Type: application/json');
            $this->response->setOutput(json_encode(['type' => 'error', 'message' => $processed_request['error']]));
            return;
        }

        $payload = $processed_request['payload'];
        $order_info = $processed_request['order_info'];
        $order_id = $order_info['order_id'];
        $notification_type = $processed_request['response_type']; // 'type' from the root of the incoming JSON

        $comment = 'HowToPay Notification Received. Type: ' . $notification_type . '. Status in data: ' . (isset($payload['status']) ? $payload['status'] : 'N/A') . '. Payload: ' . json_encode($payload);
        $this->model_checkout_order->addOrderHistory($order_id, $order_info['order_status_id'], $comment, false); // Don't notify customer for generic notifications

        if ($this->config->get('payment_howtopay_debug')) {
            $this->log->write("HowToPay Notification for order ID {$order_id}: " . $comment);
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode(['type' => 'success', 'message' => 'Notification received.']));
    }
}
