<?php
// htp_oc_plugin_v1
class ControllerExtensionPaymentHowtopay extends Controller {
    private $error = array();

    public function index() {
        $this->load->language('extension/payment/howtopay');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('setting/setting');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            // Handle checkbox values: if not present in POST, it means 0 (unchecked)
            $post_data = $this->request->post;
            if (!isset($post_data['payment_howtopay_status'])) {
                $post_data['payment_howtopay_status'] = 0;
            }
            if (!isset($post_data['payment_howtopay_sandbox'])) {
                $post_data['payment_howtopay_sandbox'] = 0;
            }
            // Handle debug checkbox
            if (!isset($post_data['payment_howtopay_debug'])) {
                $post_data['payment_howtopay_debug'] = 0;
            }

            $this->model_setting_setting->editSetting('payment_howtopay', $post_data);

            // Ensure the custom table exists
            $this->_createDbTable();

            $this->session->data['success'] = $this->language->get('text_success');

            $this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true));
        }

        // Load errors
        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }
        if (isset($this->error['title'])) {
            $data['error_title'] = $this->error['title'];
        } else {
            $data['error_title'] = '';
        }
        if (isset($this->error['api_key'])) {
            $data['error_api_key'] = $this->error['api_key'];
        } else {
            $data['error_api_key'] = '';
        }
        if (isset($this->error['secret_key'])) {
            $data['error_secret_key'] = $this->error['secret_key'];
        } else {
            $data['error_secret_key'] = '';
        }

        // Breadcrumbs
        $data['breadcrumbs'] = array();
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_extension'),
            'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true)
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('extension/payment/howtopay', 'user_token=' . $this->session->data['user_token'], true)
        );

        // Action URLs
        $data['action'] = $this->url->link('extension/payment/howtopay', 'user_token=' . $this->session->data['user_token'], true);
        $data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true);

        // Load settings with defaults
        // Enable Howtopay Gateway (Status) - checkbox, default checked (1)
        if (isset($this->request->post['payment_howtopay_status'])) {
            $data['payment_howtopay_status'] = $this->request->post['payment_howtopay_status'];
        } elseif ($this->request->server['REQUEST_METHOD'] == 'POST' && !isset($this->request->post['payment_howtopay_status'])) {
            $data['payment_howtopay_status'] = 0; // Form submitted, checkbox unchecked
        } else {
            $status_from_config = $this->config->get('payment_howtopay_status');
            $data['payment_howtopay_status'] = ($status_from_config === null) ? 1 : (int)$status_from_config;
        }

        // Title - text box, default "HowToPay"
        if (isset($this->request->post['payment_howtopay_title'])) {
            $data['payment_howtopay_title'] = $this->request->post['payment_howtopay_title'];
        } else {
            $title_from_config = $this->config->get('payment_howtopay_title');
            $data['payment_howtopay_title'] = ($title_from_config === null) ? 'HowToPay' : $title_from_config;
        }

        // Description - text area, with default
        if (isset($this->request->post['payment_howtopay_description'])) {
            $data['payment_howtopay_description'] = $this->request->post['payment_howtopay_description'];
        } else {
            $description_from_config = $this->config->get('payment_howtopay_description');
            $default_description = "<strong style='color:#1398d9'>Pay with HowToPay</strong> &#187;  In next page you'll get the payment link to complete this order. Also we will send you an email with payment options if you want to complete this payment later.";
            $data['payment_howtopay_description'] = ($description_from_config === null) ? $default_description : $description_from_config;
        }

        // Enable Sandbox mode - checkbox, default unchecked (0)
        if (isset($this->request->post['payment_howtopay_sandbox'])) {
            $data['payment_howtopay_sandbox'] = $this->request->post['payment_howtopay_sandbox'];
        } elseif ($this->request->server['REQUEST_METHOD'] == 'POST' && !isset($this->request->post['payment_howtopay_sandbox'])) {
            $data['payment_howtopay_sandbox'] = 0; // Form submitted, checkbox unchecked
        } else {
            $sandbox_from_config = $this->config->get('payment_howtopay_sandbox');
            $data['payment_howtopay_sandbox'] = ($sandbox_from_config === null) ? 0 : (int)$sandbox_from_config;
        }

        // API Key
        if (isset($this->request->post['payment_howtopay_api_key'])) {
            $data['payment_howtopay_api_key'] = $this->request->post['payment_howtopay_api_key'];
        } else {
            $data['payment_howtopay_api_key'] = $this->config->get('payment_howtopay_api_key');
        }

        // Secret Key
        if (isset($this->request->post['payment_howtopay_secret_key'])) {
            $data['payment_howtopay_secret_key'] = $this->request->post['payment_howtopay_secret_key'];
        } else {
            $data['payment_howtopay_secret_key'] = $this->config->get('payment_howtopay_secret_key');
        }

        // Sort Order
        if (isset($this->request->post['payment_howtopay_sort_order'])) {
            $data['payment_howtopay_sort_order'] = $this->request->post['payment_howtopay_sort_order'];
        } else {
            $sort_order_from_config = $this->config->get('payment_howtopay_sort_order');
            $data['payment_howtopay_sort_order'] = ($sort_order_from_config === null) ? 0 : $sort_order_from_config;
        }

        // Order Status (Initial)
        if (isset($this->request->post['payment_howtopay_order_status_id'])) {
            $data['payment_howtopay_order_status_id'] = $this->request->post['payment_howtopay_order_status_id'];
        } else {
            $order_status_id_from_config = $this->config->get('payment_howtopay_order_status_id');
            $data['payment_howtopay_order_status_id'] = ($order_status_id_from_config === null) ? $this->config->get('config_order_status_id') : $order_status_id_from_config;
        }

        // Paid Order Status
        if (isset($this->request->post['payment_howtopay_paid_status_id'])) {
            $data['payment_howtopay_paid_status_id'] = $this->request->post['payment_howtopay_paid_status_id'];
        } else {
            $paid_status_id_from_config = $this->config->get('payment_howtopay_paid_status_id');
            $data['payment_howtopay_paid_status_id'] = ($paid_status_id_from_config === null) ? 5 : $paid_status_id_from_config; // Default to 'Complete' (ID 5)
        }

        // Cancelled Order Status
        if (isset($this->request->post['payment_howtopay_cancelled_status_id'])) {
            $data['payment_howtopay_cancelled_status_id'] = $this->request->post['payment_howtopay_cancelled_status_id'];
        } else {
            $cancelled_status_id_from_config = $this->config->get('payment_howtopay_cancelled_status_id');
            $data['payment_howtopay_cancelled_status_id'] = ($cancelled_status_id_from_config === null) ? 7 : $cancelled_status_id_from_config; // Default to 'Canceled' (ID 7)
        }

        // Underpayment Order Status
        if (isset($this->request->post['payment_howtopay_underpayment_status_id'])) {
            $data['payment_howtopay_underpayment_status_id'] = $this->request->post['payment_howtopay_underpayment_status_id'];
        } else {
            $underpayment_status_id_from_config = $this->config->get('payment_howtopay_underpayment_status_id');
            $data['payment_howtopay_underpayment_status_id'] = ($underpayment_status_id_from_config === null) ? 1 : $underpayment_status_id_from_config; // Default to 'Pending' (ID 1)
        }

        $this->load->model('localisation/order_status');
        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

        // Geo Zone
        if (isset($this->request->post['payment_howtopay_geo_zone_id'])) {
            $data['payment_howtopay_geo_zone_id'] = $this->request->post['payment_howtopay_geo_zone_id'];
        } else {
            $data['payment_howtopay_geo_zone_id'] = $this->config->get('payment_howtopay_geo_zone_id');
        }
        $this->load->model('localisation/geo_zone');
        $data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();

        // Minimum Total
        $data['payment_howtopay_total'] = isset($this->request->post['payment_howtopay_total']) ? $this->request->post['payment_howtopay_total'] : $this->config->get('payment_howtopay_total');

        // Debug Logging
        if (isset($this->request->post['payment_howtopay_debug'])) {
            $data['payment_howtopay_debug'] = $this->request->post['payment_howtopay_debug'];
        } elseif ($this->request->server['REQUEST_METHOD'] == 'POST' && !isset($this->request->post['payment_howtopay_debug'])) {
            $data['payment_howtopay_debug'] = 0; // Form submitted, checkbox unchecked
        } else {
            $debug_from_config = $this->config->get('payment_howtopay_debug');
            $data['payment_howtopay_debug'] = ($debug_from_config === null) ? 0 : (int)$debug_from_config;
        }

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('extension/payment/howtopay', $data));
    }

    protected function validate() {
        if (!$this->user->hasPermission('modify', 'extension/payment/howtopay')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (empty($this->request->post['payment_howtopay_title'])) {
            $this->error['title'] = $this->language->get('error_title');
        }

        // Validate API Key and Secret Key only if the gateway is enabled
        // The 'payment_howtopay_status' checkbox will have value '1' if checked, or not be present in POST if unchecked.
        if (isset($this->request->post['payment_howtopay_status']) && $this->request->post['payment_howtopay_status'] == '1') {
            if (empty($this->request->post['payment_howtopay_api_key'])) {
                $this->error['api_key'] = $this->language->get('error_api_key');
            }

            if (empty($this->request->post['payment_howtopay_secret_key'])) {
                $this->error['secret_key'] = $this->language->get('error_secret_key');
            }

            // If keys are provided and no other key-related errors, attempt to validate them with the API server
            if (empty($this->error['api_key']) && empty($this->error['secret_key'])) {
                $library_file = DIR_SYSTEM . 'library/howtopayapi.php'; // Ensure this matches your library file name

                if (file_exists($library_file)) {
                    require_once($library_file);

                    $api_key = trim($this->request->post['payment_howtopay_api_key']);
                    $secret_key = trim($this->request->post['payment_howtopay_secret_key']);
                    $is_sandbox = (isset($this->request->post['payment_howtopay_sandbox']) && $this->request->post['payment_howtopay_sandbox'] == '1');

                    // Ensure the class name matches the one in your library file
                    $howtopay_api_client = new HowtopayApi($api_key, $secret_key, $is_sandbox);
                    
                    $results = $howtopay_api_client->checkConnection();

                    if (isset($results['type']) && $results['type'] == "error") {
                        $error_message = $this->language->get('error_api_connection_failed');
                        if (!empty($results['message'])) {
                            $error_message .= ' ' . $results['message'];
                        }
                        $this->error['warning'] = $error_message; // Overwrite or append as needed
                    }
                } else {
                    $this->error['warning'] = 'Error: HowToPay API library file not found!';
                }
            }
        }

        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    private function _createDbTable() {
        // Create custom table for HowToPay order data
        $this->db->query("
            CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "howtopay_order` (
                `howtopay_order_id` INT(11) NOT NULL AUTO_INCREMENT,
                `order_id` INT(11) NOT NULL,
                `merchant_reference_no` VARCHAR(255) DEFAULT NULL,
                `howtopay_invoice_no` VARCHAR(255) DEFAULT NULL,
                PRIMARY KEY (`howtopay_order_id`),
                KEY `merchant_reference_no` (`merchant_reference_no`),
                KEY `order_id` (`order_id`)
            ) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
        ");
    }

    public function install() {
        $this->load->model('setting/setting');
        // Default settings
        $this->model_setting_setting->editSetting('payment_howtopay', [
            'payment_howtopay_status'         => 1, // Enabled by default
            'payment_howtopay_title'          => 'HowToPay',
            'payment_howtopay_description'    => "Pay with HowToPay &#187;  In next page you'll get the payment link to complete this order. Also we will send you an email with payment options if you want to complete this payment later.",
            'payment_howtopay_sandbox'        => 0, // Sandbox disabled by default
            'payment_howtopay_api_key'        => '',
            'payment_howtopay_secret_key'     => '',
            'payment_howtopay_sort_order'     => 0,
            'payment_howtopay_order_status_id' => $this->config->get('config_order_status_id'), // Default to OpenCart's default
            'payment_howtopay_paid_status_id' => ($this->config->get('config_complete_status_id') ? (is_array($this->config->get('config_complete_status_id')) ? $this->config->get('config_complete_status_id')[0] : $this->config->get('config_complete_status_id')) : 5), // Default to 'Complete' (ID 5)
            'payment_howtopay_cancelled_status_id' => 7, // Default to 'Cancelled'
            'payment_howtopay_underpayment_status_id' => 1, // Default to 'Pending' or a custom status
            'payment_howtopay_geo_zone_id'    => 0, // Default to 'All Zones'
            'payment_howtopay_total'          => '', // Default to no minimum
            'payment_howtopay_debug'          => 0 // Debug disabled by default
        ]);

        // Create custom table
        $this->_createDbTable();
    }

    public function uninstall() {
        $this->load->model('setting/setting');
        $this->model_setting_setting->deleteSetting('payment_howtopay');

        // Drop custom table
        // $this->db->query("DROP TABLE IF EXISTS `" . DB_PREFIX . "howtopay_order`;"); // DON'T DROP TABLE
    }
}


?>